## ################
## data loading
## ################
load("mydata.RData")

##############################################
## definition of parameters for the simulation
##############################################
length = mydata[, "#nt"]   
# vector: length of genomes

percG = mydata[, "#G"]/mydata[, "#nt"]
percC = mydata[, "#C"]/mydata[, "#nt"]
percA = (1 - percG - percC)/2
percT = (1 - percG - percC)/2
perc = cbind(percG, percC, percA, percT)   
# matrix: G/C/A/T proportions per genome

nvir = nrow(mydata)

nsim = 1
# number of replicates for each virus

#####################
## working directory 
#####################
system("mkdir sim")
setwd("./sim")

## Instructions are for Unix/Linux OS


##############
## simulation
##############
for(virIdx in 1:nvir)
{  
  ifelse(virIdx == 1, 
         system(paste("mkdir nvir", virIdx, sep="")),
         system(paste("mkdir ../nvir", virIdx, sep="")))
  ifelse(virIdx == 1, 
         setwd(paste("./nvir", virIdx, sep="")),
         setwd(paste("../nvir", virIdx, sep=""))) 
  for(idx in 1:nsim)
  {  
    sim = sample(c("G","C","A","T"), length[virIdx], replace=T, 
                 prob=perc[virIdx,]/100)
    write.table(paste(sim, collapse=""), paste("sim", idx, ".txt", sep=""), 
                quote=F, sep="", row.names=F, col.names=F)
  }
  print(virIdx)   # counter: virus
}  
